/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth.util;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.ui.bonsai.config.BonsaiConfigException;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.Targetable;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.earth.util.AbstractTreeTaskRetriever;
import com.ibm.hwmca.ui.bonsai.earth.util.UserRolePermissionsSet;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class KeyTreeTaskRetriever
extends AbstractTreeTaskRetriever {
    private String tasksType;
    private Set permittedRoles;
    private Set tasks;

    public void init(String key, Map params) throws BonsaiConfigException {
        super.init(key, params);
        String keysParam = (String)params.get("keys");
        this.tasksType = (String)params.get("type");
        if (keysParam == null || this.tasksType == null) {
            throw new BonsaiConfigException("No task keys or tasks type was specified in the XML!");
        }
        if (!this.tasksType.equals("targeted") && !this.tasksType.equals("untargeted")) {
            throw new BonsaiConfigException("The tasks type must be 'targeted' or 'untargeted' for " + key + "!");
        }
        this.permittedRoles = new HashSet();
        this.tasks = new HashSet();
        ShortObjectIdManager idManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
        ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
        String task = null;
        UserRolePermissionsSet permSet = null;
        StringTokenizer tokens = new StringTokenizer(keysParam, ";");
        while (tokens.hasMoreTokens()) {
            objId.setKeyProperty("Name", tokens.nextToken());
            task = idManager.getShortId(objId);
            if (task == null) continue;
            this.tasks.add(task);
            permSet = new UserRolePermissionsSet(objId);
            this.permittedRoles.addAll(permSet.getPermittedRoles());
        }
    }

    public List getTasks(BonsaiTreeNode node, UserObject userObj) {
        HashSet taskIds = new HashSet(this.tasks);
        if (this.tasksType.equals("targeted")) {
            Set targetableTasks = userObj.getUIObjectsReader().getAllowedTasks(((Targetable)((Object)node)).getShortId());
            Iterator i = taskIds.iterator();
            while (i.hasNext()) {
                if (targetableTasks.contains(i.next())) continue;
                i.remove();
            }
        }
        return this.getTaskTrees(taskIds);
    }

    public Set getPermittedUserRoles() {
        return this.permittedRoles;
    }

    protected TaskNode getClone(TaskNode node) {
        TaskNode clone = null;
        if (this.tasksType.equals("untargeted")) {
            clone = node.getNoChildrenNoUrlClone();
            clone.setUrl(new TaskUrl(node.getId(), 1));
        } else {
            clone = node.getNoChildrenClone();
        }
        return clone;
    }
}

